<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;

use App\Http\Controllers\RevenueshareController;
use App\Http\Controllers\AccountclosureController;
use App\Http\Controllers\ContentmappingController;
use App\Http\Controllers\YoutubeController;
use App\Http\Controllers\OpencallController;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;



    
    Route::post('/clear-flash', function () {
        session()->forget('success');
        session()->forget('error');
        return response()->json(['status' => 'cleared']);
    })->name('clear.flash');
    
    Route::get('/pageerror', function () {
        return view('pageerror');
    });
   
    
Route::get('/formlogout/{key}', [LoginController::class, 'formlogout'])->name('formlogout');

Route::get('/account_form/{key}/{username}', [AccountclosureController::class, 'forms'])->name('account_form');
Route::get('/accountclosureform', [AccountclosureController::class, 'form'])->name('accountclosureform')->middleware('block.bad.agents');
Route::post('/formsubmit', [AccountclosureController::class, 'formsubmit'])->name('formsubmit');


Route::get('/revenueform/{key}/{username}', [RevenueshareController::class, 'forms'])->name('revenueform');
Route::get('/revenueshareforms', [RevenueshareController::class, 'form'])->name('revenueshareforms')->middleware('block.bad.agents');
Route::get('/revenueformsubmit', [RevenueshareController::class, 'revenueformsubmit'])->name('revenueformsubmit');
Route::post('/getupcDetails1', [RevenueshareController::class, 'getupcDetails1'])->name('getupcDetails1');
Route::post('/getupcDetails11', [RevenueshareController::class, 'getupcDetails11'])->name('getupcDetails11');


Route::get('/content_forms/{key}/{username}', [ContentmappingController::class, 'forms'])->name('content_forms');
Route::get('/Contentmappingform', [ContentmappingController::class, 'form'])->name('Contentmappingform')->middleware('block.bad.agents');
Route::post('/contentformsubmit', [ContentmappingController::class, 'contentformsubmit'])->name('contentformsubmit');
Route::post('/getupcDetails2', [ContentmappingController::class, 'getupcDetails2'])->name('getupcDetails2');
Route::post('/upc', [OpencallController::class, 'upc']);
Route::get('/usersearch', [ContentmappingController::class, 'usersearch'])->name('usersearch');
Route::get('/getcorresvalues', [ContentmappingController::class, 'getcorresvalues'])->name('getcorresvalues');

Route::get('/youtube_oacs/{key}/{username}', [YoutubeController::class, 'forms'])->name('youtube_oacs');
Route::get('/youtubeoac', [YoutubeController::class, 'form'])->name('youtubeoac')->middleware('block.bad.agents');
Route::post('/oacformsubmit', [YoutubeController::class, 'oacformsubmit'])->name('oacformsubmit');
Route::post('/checkbadflags', [YoutubeController::class, 'checkbadflags'])->name('checkbadflags');
Route::post('/check-oac-duplicates', [YoutubeController::class, 'checkDuplicates'])->name('check.oac.duplicates');
Route::post('/getartistnames', [YoutubeController::class, 'getartistnames'])->name('getartistnames');
Route::post('/getupcDetails', [YoutubeController::class, 'getupcDetails'])->name('getupcDetails');



Route::match(['get', 'put', 'delete'], '/getupcDetails11', function () {
    abort(404);
});

Route::fallback(function () {
    return response()->view('errors.404', [], 404);
   });

