<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <link rel="stylesheet" href="<?php echo e(asset('header/header.css')); ?>">


    <title>Magiclink - RN</title>

    <style>
        body {
            font-family: Roboto, RobotoDraft, Helvetica, Arial, sans-serif !important;
            background-color: #efebf8;
        }

        .pad {
            padding: 5px 20px;
        }

        a {
            // text-decoration: none;
        }

        p {
            text-align: justify;
            font-size: 15px;
            font-family: system-ui
        }

        input:focus-visible {
            border: none;
            outline: none;
        }

        input[type="radio"] {
            width: 18px;
            height: 18px;
            filter: hue-rotate(45deg);
            cursor: pointer;
        }

        .uncheck_btn {
            float: right;
            margin: 20px 0;
            background: none;
            border: none;
            padding: 10px;
            border-radius: 7px;
            display: none;
        }

        .uncheck_btn:hover {
            background: #f0f0f0;
        }

        .success {
            background-color: #5a39b6;
            color: #fff;
            padding: 10px 25px;
            border-radius: 5px;
            border: none;
            filter: drop-shadow(0px 2px 2px black);
        }

        .top_bg {
            background-image: url('https://magiclink.rn-test.com/images/formimg.png');
            background-size: cover;
            max-height: 23vw;
            max-width: 90vw;
            height: 160px;
            width: 641px;
            border-radius: 8px;
        }

        .cont1 {
            background-color: #fff;
            border: 1px solid #dfdfdf;
            border-radius: 10px;
            margin-top: 12px;
            border-top: 11px solid rgb(90, 57, 182);
        }

        .cont2 {
            background-color: #fff;
            border: 1px solid #dfdfdf;
            border-radius: 10px;
            margin-top: 12px;
            overflow: hidden;
        }

        .btn {
            background: #f0eaf8;
            color: rgb(90, 57, 182);
            padding: 10px 25px;
            border-radius: 5px;
            border: none;
            filter: drop-shadow(0px 2px 2px black);
        }

        #form3,
        #form2,
        #success {
            display: none;
        }

        .headings p {
            margin: auto 0;
            font-weight: 400;
        }

        .headings div {
            height: 40px;
        }


        .badge_right_menu {
            color: white;
            transform: scale(1.8);
            line-height: normal;
            width: 6rem;
            margin-left: 34px;
        }

        .badge_right_menu ion-icon {
            cursor: pointer;
        }

    .top_user_inert {
        display: none;
        position: fixed;
        background-color: #fff;
        border: 1px solid #ccc;
        padding: 22px;
        /* max-width: 400px; */
        box-shadow: 0px 5px 10px rgba(0, 0, 0, 0.2);
        z-index: 99;
        /* width: max-content; */
        width: 25rem;
        border-radius: 8px;
        right: 2.5rem;
        top: 4.5rem;
    }

    .top_user_open {
        display: block;
        animation: slideDown 0.3s ease-in-out;
    }

    .top_user_inert .user_head {
        display: flex;
    }

    .top_user_inert .user_head .logout_head {
        width: 20%;
        display: flex;
        justify-content: end;
    }

    .top_user_inert .user_head .logout_head ion-icon {
        height: 24px;
        width: 24px;
        cursor: pointer;
    }

    .top_user_inert .split_head {
        // width: 80%;
		width: 100%;
        display: flex;
		height: 70px;
    }

    .top_user_inert .user_head .split_head div {
        /*            width: 19%;*/
        margin-right: 14px;
        position: relative;
    }

    .top_user_inert .user_head .split_head div img {
        width: 100% !important;
    }

    .top_user_inert .user_head .split_head div p {
        margin: 1px;
        font-weight: 700;
        margin-bottom: 0;
    }

    .top_user_inert .user_head .split_head div .unqiue {
        font-size: 11px;
        color: #7e7e7e;
    }

    .top_user_inert .user_head .split_head div .sub_time {
        font-size: 11px;
        background: #0080002e;
        padding: 2px 9px;
        border-radius: 31px;
        color: green;
		width: max-content;
    }

    .top_user_inert .user_body {
        padding: 1.5rem 0rem 1rem 0;
        position: relative;
        /* height: 200px;
            overflow-x: auto; */
    }

    .top_user_inert .user_body .out_of_card_first {
        padding: 1rem;
        border: 1px solid #dfdfdf;
        border-radius: 8px;
        display: flex;
        justify-content: space-between;
    }

    .top_user_inert .user_body .out_of_card_first ion-icon {
        /*            transform: scale(2);*/
    }

    .top_user_inert .user_head .split_head div .status_res {
        height: 14px;
        width: 14px;
        background: green;
        border: 2px solid #fff;
        border-radius: 50%;
        position: absolute;
        right: -8px;
        bottom: 5px;
        /* cursor: pointer; */
    }

    /* .top_user_inert .user_head .split_head div .status_res:hover {
        background-color: #bbb !important;
    } */

    /* .top_user_inert .user_head .split_head div .status_res:hover::before {
        content: "^";
        display: flex;
        align-items: center;
        justify-content: center;
        margin: -10px 0 0;
        transform: rotate(180deg);
    } */

    .top_user_inert .user_head .split_head .popup_status {
        position: absolute;
        height: max-content;
        width: 5rem;
        background: #fff;
        border-radius: 4px;
        top: 74px;
        left: 71px;
        z-index: 9999;
        border: 1px solid #ddd;
        display: none;
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
    }

    .top_user_inert .user_head .split_head .popup_status p {
        font-size: small;
        font-weight: 400;
        text-align: center;
        display: flex;
        justify-content: space-around;
        padding: 4px;
        margin: 0;
        cursor: pointer;
    }

    .top_user_inert .user_head .split_head .popup_status p:hover {
        background-color: #ddd;
    }

    .top_user_inert .user_head .split_head div .status_res div {
        border: 3px solid #fff;
        border-radius: 50%;
        position: relative;
        right: -2px;
        bottom: -2px;
        display: none;
    }

    .top_user_inert .user_body .dont_dis_card_sec {
        padding: 1rem;
        border: 1px solid #dfdfdf;
        border-radius: 8px;
        display: flex;
        justify-content: space-between;
        margin-top: 8px;
    }

    .top_user_inert .user_body .dont_dis_card_sec .moon_circle_in {
        background: #ff9a03;
        padding: 2px;
        border: 2px solid #ff9a03;
        display: flex;
        align-items: center;
        border-radius: 50%;
        height: 26px;
        width: 26px;
        position: relative;
    }

    /*    .top_user_inert .user_body .dont_dis_card_sec .moon_circle_in div {
            border-right: 2px solid;
            height: 1.3rem;
            transform: rotate(-45deg);
            position: absolute;
            left: 10px;
            border-color: #000000;
            top: 1px;
        }*/
    .top_user_inert .user_body .dont_dis_card_sec .moon_circle_in span {
        background: white;
        width: 2px;
        height: 21px;
        transform: rotate(-45deg);
        position: absolute;
        left: 9px;
        top: 1px;
        border: 1px solid #ff9a03;
        padding-right: 2px;
        display: none;
        border-bottom: none;
        border-top: none;
        border-radius: 11px;
    }

    .top_user_inert .option_out {
        display: flex;
        justify-content: end;
    }

    .top_user_inert .option_out .logout_outline {
        display: flex;
        align-items: center;
        gap: 2px;
        cursor: pointer;
    }

    .top_user_inert .option_out .logout_outline ion-icon {
        color: black;
        transform: scale(1.2);
    }

    .top_user_inert .option_out .logout_outline span {
        color: black;
    }

    .top_user_inert .user_body .schedule_timeset {
        padding: 1rem;
        border: 1px solid #dfdfdf;
        border-radius: 8px;
        display: flex;
        justify-content: space-between;
        margin-top: 8px;
    }

    .top_user_inert .user_body .schedule_timeset .moon_circle_in {
        background: #ff9a03;
        padding: 3px;
        border: 2px solid #ff9a03;
        display: flex;
        align-items: center;
        border-radius: 50%;
        height: 26px;
        width: 26px;
        justify-content: center;
        position: relative;
    }

    .top_user_inert .user_body .schedule_timeset .moon_circle_in #jUF221fvd {
        height: 8px;
        width: 8px;
        position: absolute;
        background: #ff9a03;
        display: flex;
        justify-content: center;
        border-radius: 50%;
        align-items: center;
        color: white;
        top: 1px;
        left: 13px;
        font-size: 8px;
    }

    .top_user_inert .user_body .schedule_timeset .moon_circle_in img {
        width: 18px;
        height: 24px;
    }

    .top_user_inert .user_body .schedule_timeset input {
        background: #cfcfcf47;
        border: none;
        border-radius: 7px;
        width: 44%;
        color: #212121;
        font-size: small;
        padding: 3px;
        font-size: 12px;
    }

    .top_user_inert .user_body .schedule_timeset span {
        font-size: 12px;
        padding: 0 2px;
    }

    /* switch */
    .user_head_uni_switch .bell_switch {
        position: relative;
        display: inline-block;
        width: 36px;
        /*            height: 22px;*/
        height: 29px;
    }

    .user_head_uni_switch .bell_switch input {
        display: none;
    }

    .user_head_uni_switch .bell_switch label {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        border-radius: 34px;
        cursor: pointer;
        transition: background-color 0.3s;
        margin-bottom: 0.5rem;
    }

    .user_head_uni_switch .bell_switch input:checked+label {
        background-color: #2196F3;
    }

    .user_head_uni_switch .bell_switch label:before {
        position: absolute;
        content: "";
        height: 13px;
        width: 13px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        border-radius: 50%;
        transition: transform 0.3s;
    }

    .user_head_uni_switch .bell_switch input:checked+label:before {
        transform: translateX(16px);
    }
	.top_user_inert .user_head .split_head div .sub_time {
		display:block;
	}
	.top_user_inert .user_head .split_head div .sub_time_do {
		// padding: 2px 9px;
		// border-radius: 31px;
		// font-size: 11px;
		// background: #ff9a033d;
		// color: #ff9a03;
		// width: max-content;
		display:none;
	}
	.top_user_inert .user_head .split_head div .sub_time_out {
		// padding: 2px 9px;
		// border-radius: 31px;
		// font-size: 11px;
		// background: #ffc4c4;
		// color: #ff4e4e;
		// width: max-content;
		display:none;
	}

    .admin_box{
        display: none;
    }

    </style>
	<style>
    .error-message {
        color: red;
        font-size: 14px;
    }
</style>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
function validateForm() {
            
            var isValid = true;

            isValid &= validateField('email', '* Indicates required email.');
            isValid &= validateField('username', '* Indicates required username.');
            isValid &= validateField('user_id', '* Indicates required user ID.');
            isValid &= validateField('comments', '* Indicates required comments.');
            isValid &= validateField('commentss', '* Indicates required comments.');
			
            var closeOption = $('input[name="close"]:checked').val();
            var satisfiedOption = $('input[name="satisfied"]:checked').val();
            var accountOption = $('input[name="account"]:checked').val();
            // var optionsOption = $('input[name="options"]:checked').val();
         
            isValid &= validateRadio('account', accountOption, 'Please select a reason for closing your account');

            isValid &= validateRadio('close', closeOption, 'Please select a close option');
            isValid &= validateRadio('satisfied', satisfiedOption, 'Please rate your satisfaction');

            // isValid &= validateRadio('options', optionsOption, 'Please select a anyone option');
         
            isValid &= validateField('comments', '* Please provide your suggestions to improve the experience.');
            isValid &= validateField('commentss', '* Please provide your suggestions to improve the experience.');

            return isValid;
        }
    
        function validateField(fieldName, errorMessage) {
            var fieldValue = $('#' + fieldName).val().trim();
            var errorMessageId = '#' + fieldName + '-error';

            if (fieldValue == '') {
                $('#comments-error').css('display', 'block');
                showError(errorMessageId, errorMessage);
                return false;
            } else {
                $('#comments-error').css('display', 'none');
                hideError(errorMessageId);
                return true;
            }
        }

        function validateRadio(fieldName, fieldValue, errorMessage) {
            var errorMessageId = '#' + fieldName + '-error';

            if (!fieldValue) {
                showError(errorMessageId, errorMessage);
                return false;
            } else {
                hideError(errorMessageId);
                return true;
            }
        }

        function showError(errorMessageId, message) {
            $(errorMessageId).html('<span class="error-message">' + message + '</span>');
        }

        function hideError(errorMessageId) {
            $(errorMessageId).html('');
        }


    function form1_back() {
        $('#options-error,#service-error, #product-error, #pricing-error').hide();
        $('#form1').css('display', 'block');
        $('#form2').css('display', 'none');
        $('#form3').css('display', 'none');
        //$('#success').css('display', 'none');
        $('#service').css('display', 'none');
        $('#product').css('display', 'none');
        $('#newsubmit').css('display', 'none');
        $('#pricing').css('display', 'none');
        $('#close_account').css('outline', 'none');
        $('#close_account').removeClass('blinking');

    }


    function form32_back() {
        $('#options-error,#service-error, #product-error, #pricing-error').hide();
        $('#form1').css('display', 'none');
        $('#form2').css('display', 'none');
        $('#form3').css('display', 'none');
        //$('#success').css('display', 'none');
        $('#service').css('display', 'block');
        $('#product').css('display', 'none');
        $('#newsubmit').css('display', 'none');
        $('#pricing').css('display', 'none');
        $('#close_account').css('outline', 'none');
        $('#close_account').removeClass('blinking');

    }


    function form42_back() {
        $('#options-error,#service-error, #product-error, #pricing-error').hide();
        $('#form1').css('display', 'none');
        $('#form2').css('display', 'none');
        $('#form3').css('display', 'none');
        //$('#success').css('display', 'none');
        $('#service').css('display', 'none');
        $('#product').css('display', 'block');
        $('#newsubmit').css('display', 'none');
        $('#pricing').css('display', 'none');
        $('#close_account').css('outline', 'none');
        $('#close_account').removeClass('blinking');

    }

    function form52_back() {
        $('#options-error,#service-error, #product-error, #pricing-error').hide();
        $('#form1').css('display', 'none');
        $('#form2').css('display', 'none');
        $('#form3').css('display', 'none');
        //$('#success').css('display', 'none');
        $('#service').css('display', 'none');
        $('#product').css('display', 'none');
        $('#newsubmit').css('display', 'none');
        $('#pricing').css('display', 'block');
        $('#close_account').css('outline', 'none');
        $('#close_account').removeClass('blinking');

    }

    function form2_next() {

        var serviceValue = document.querySelector('input[name="service"]:checked')?.value;
        var productValue = document.querySelector('input[name="product"]:checked')?.value;
        var pricingValue = document.querySelector('input[name="pricing"]:checked')?.value;

        var savedValue = $('#form_ids').text();

        if(savedValue === "3"){
            if (!serviceValue) {
            $('#service-error').show();
            return;
            }
        }
        if(savedValue === "4"){
            if (!productValue) {
            $('#product-error').show();
            return;
            }
        }
        if(savedValue === "5"){
            if (!pricingValue) {
            $('#pricing-error').show();
            return;
            }
        }

        $('#options-error,#service-error, #product-error, #pricing-error').hide();
	
        $('#form1').css('display', 'none');
        $('#form2').css('display', 'block');
        $('#form3').css('display', 'none');
       // $('#success').css('display', 'none');
        $('#newsubmit').css('display', 'none');
        $('#service').css('display', 'none');
        $('#product').css('display', 'none');
        $('#pricing').css('display', 'none');
        $('#close_account').css('outline', 'none');
        $('#close_account').removeClass('blinking');


    }

    function form3_next() {

        var optionsButtons = document.getElementsByName('options');
        var optionsValue;
        for (var i = 0; i < optionsButtons.length; i++) {
            if (optionsButtons[i].checked) {
                optionsValue = optionsButtons[i].value;
                break;
            }
        }

        if(!optionsValue){
            $('#options-error').css('display', 'block');
            return;
        }

        $('#options-error').css('display', 'none');

        $('#form1').css('display', 'none');
        $('#form2').css('display', 'none');
        $('#form3').css('display', 'block');
       // $('#success').css('display', 'none');
        $('#newsubmit').css('display', 'none');
        $('#service').css('display', 'none');
        $('#product').css('display', 'none');
        $('#pricing').css('display', 'none');
        $('#close_account').css('outline', 'none');
        $('#close_account').removeClass('blinking');

    }

    function form3_back() {
        $('#options-error,#service-error, #product-error, #pricing-error').hide();
        $('#form1').css('display', 'none');
        $('#form2').css('display', 'block');
        $('#form3').css('display', 'none');
        $('#newsubmit').css('display', 'none');
       // $('#success').css('display', 'none');
        $('#service').css('display', 'none');
        $('#product').css('display', 'none');
        $('#pricing').css('display', 'none');
        $('#close_account').css('outline', 'none');
        $('#close_account').removeClass('blinking');
    }

    function success() {
		if (validateForm()) {
        $('#form1').css('display', 'none');
        $('#form2').css('display', 'none');
        $('#form3').css('display', 'none');
       // $('#success').css('display', 'block');
        $('#service').css('display', 'none');
        $('#product').css('display', 'none');
        $('#pricing').css('display', 'none');
        $('#close_account').css('outline', 'none');
        $('#newsubmit').css('display', 'none');
        $('#close_account').removeClass('blinking');
    }
	}
    $(document).ready(function () {
		
        var checkedCount = 0;
        var emailValue = '';
        var usernameValue = '';
        var userIdValue = '';

        $('input[name="close"]').on('change', function () {
            handleBlinking('#immediately', $(this).prop('checked'));
            //updateCheckedCountAndValues();
        });

        $('input[name="satisfied"]').on('change', function () {
            handleBlinking('#close_satisfied', $(this).prop('checked'));
           // updateCheckedCountAndValues();
        });

        $('input[name="account"]').on('change', function () {
            handleBlinking('#close_account', $(this).prop('checked'));
           // updateCheckedCountAndValues();
        });

$('input[name="options"]').on('change', function () {
            handleBlinking('#distributor', $(this).prop('checked'));
           // updateCheckedCountAndValues();
        });

        $('#email').on('input', function () {
            emailValue = $(this).val();
            handleBlinking('#email', emailValue.trim() === ''); // Check if the trimmed value is empty
           // updateCheckedCountAndValues();

            if (emailValue.trim() !== '') {
                $('#email').removeClass('blinking');
            }
        });


        $('#username').on('input', function () {
            usernameValue = $(this).val();
            handleBlinking('#username', usernameValue.trim() === ''); // Check if the trimmed value is empty
           // updateCheckedCountAndValues();

            if (usernameValue.trim() !== '') {
                $('#username').removeClass('blinking');
            }
        });

        $('#user_id').on('input', function () {
            userIdValue = $(this).val();
            handleBlinking('#user_id', userIdValue.trim() === ''); // Check if the trimmed value is empty
           // updateCheckedCountAndValues();

            if (userIdValue.trim() !== '') {
                $('#user_id').removeClass('blinking');
            }
        });
   $('#comments').on('input', function () {
            commentsValue = $(this).val();
            handleBlinking('#comments', commentsValue.trim() === ''); // Check if the trimmed value is empty
           // updateCheckedCountAndValues();

            if (commentsValue.trim() !== '') {
                $('#comments').removeClass('blinking');
            }
        });
        $('#commentss').on('input', function () {
            commentsValue = $(this).val();
            handleBlinking('#commentss', commentsValue.trim() === ''); // Check if the trimmed value is empty
           // updateCheckedCountAndValues();

            if (commentsValue.trim() !== '') {
                $('#commentss').removeClass('blinking');
            }
        });
        function handleBlinking(elementId, hasNoValue) {
            if (hasNoValue) {
                $(elementId).removeClass('blinking');
            } else {
                $(elementId).addClass('blinking');
            }
        }

        // function updateCheckedCountAndValues() {
        //     checkedCount = $('input[name="close"]:checked, input[name="satisfied"]:checked, input[name="account"]:checked, input[name="options"]:checked').length;

        //     if (checkedCount === 3 && emailValue.trim() !== '' && usernameValue.trim() !== '' && userIdValue.trim() !== '') {
        //         $('#choose_options').css('display', 'none');
        //         $('#form1_next').css('display', 'block');
        //     } else {
        //         $('#form1_next').css('display', 'none');
        //         $('#choose_options').css('display', 'block');
        //     }
        // }
	
		//   $('#choose_options').click(function (e) {
        //     e.preventDefault();
        //     if (validateForm()) {
        // $('#close_satisfied').addClass('blinking');
        // $('#immediately').addClass('blinking');
        // $('#close_account').addClass('blinking');
        // $('#email').addClass('blinking');
        // $('#username').addClass('blinking');
        // $('#user_id').addClass('blinking');
        //     }
        // });
	$('#form1_next').click(function (e) {
    e.preventDefault(); 
    if (validateForm()) {
        $('#close_satisfied').addClass('blinking');
        $('#immediately').addClass('blinking');
        $('#close_account').addClass('blinking');
        $('#email').addClass('blinking');
        $('#username').addClass('blinking');
        $('#user_id').addClass('blinking');
        return;
            }
            


    var radioButtons = document.getElementsByName('account');
        var selectedValue;
        for (var i = 0; i < radioButtons.length; i++) {
            if (radioButtons[i].checked) {
                selectedValue = radioButtons[i].value;
                break;
            }
        }

        var satisfiedButtons = document.getElementsByName('satisfied');
        var satisfiedValue;
        for (var i = 0; i < satisfiedButtons.length; i++) {
            if (satisfiedButtons[i].checked) {
                satisfiedValue = satisfiedButtons[i].value;
                break;
            }
        }

        var closeButtons = document.getElementsByName('close');
        var closeValue;
        for (var i = 0; i < closeButtons.length; i++) {
            if (closeButtons[i].checked) {
                closeValue = closeButtons[i].value;
                break;
            }
        }

        if(!satisfiedValue){
            return;
        }

        if(!closeValue){
            return;
        }

        // alert(closeValue);

    if (selectedValue) {
        document.getElementById("form_ids").innerText = selectedValue; 
    }
   
        if (selectedValue === "1") {
            $('#form1').css('display', 'none');
            $('#form2').css('display', 'block');
            $('#form3').css('display', 'none');
           // $('#success').css('display', 'none');
            $('#service').css('display', 'none');
            $('#product').css('display', 'none');
            $('#newsubmit').css('display', 'none');
			 
        }
        else if (selectedValue === "3") {
            $('#form1').css('display', 'none');
            $('#form2').css('display', 'none');
            $('#form3').css('display', 'none');
           // $('#success').css('display', 'none');
            $('#service').css('display', 'block');
            $('#newsubmit').css('display', 'none');
            $('#product').css('display', 'none');
			
        }
        else if (selectedValue === "2") {
            $('#form1').css('display', 'none');
            $('#form2').css('display', 'none');
            $('#form3').css('display', 'none');
           // $('#success').css('display', 'none');
            $('#service').css('display', 'none');
            $('#newsubmit').css('display', 'block');
            $('#product').css('display', 'none');
			 
        } else if (selectedValue === "4") {
            $('#form1').css('display', 'none');
            $('#form2').css('display', 'none');
            $('#form3').css('display', 'none');
           // $('#success').css('display', 'none');
            $('#newsubmit').css('display', 'none');
            $('#service').css('display', 'none');
            $('#product').css('display', 'block');
            $('#pricing').css('display', 'none');
			 
        }
        else if (selectedValue === "5") {
            $('#form1').css('display', 'none');
            $('#form2').css('display', 'none');
            $('#form3').css('display', 'none');
            //$('#success').css('display', 'none');
            $('#service').css('display', 'none');
            $('#newsubmit').css('display', 'none');
            $('#product').css('display', 'none');
            $('#pricing').css('display', 'block');
			 
        }
        else if (selectedValue === "6") {
            $('#form1').css('display', 'none');
            $('#form2').css('display', 'block');
            $('#form3').css('display', 'none');
          //  $('#success').css('display', 'none');
            $('#service').css('display', 'none');
            $('#newsubmit').css('display', 'none');
            $('#product').css('display', 'none');
            $('#pricing').css('display', 'none');
			
        }

});

$('#form2_next').click(function (e) {
    e.preventDefault(); 
    form3_next(); 
});	
$('#form22_next').click(function (e) {
    e.preventDefault(); 
    form2_next(); 
}); 
	$('#form23_next').click(function (e) {
    e.preventDefault(); 
    form2_next(); 
}); 	
$('#form24_next').click(function (e) {
    e.preventDefault(); 
    form2_next(); 
});
$('#form2_back').click(function (e) {
    e.preventDefault(); 

    var savedValue = $('#form_ids').text();

    if(savedValue === "1"){
        form1_back();
    }
    else if(savedValue === "2"){
        form1_back();
    }
    else if(savedValue === "3"){
        form32_back();
    }
    else if(savedValue === "4"){
        form42_back();
    }
    else if(savedValue === "5"){
        form52_back();
    }
    else if(savedValue === "6"){
        form1_back();
    }

});
$('#form22_back').click(function (e) {
    e.preventDefault(); 
    form1_back();
});
$('#form23_back').click(function (e) {
    e.preventDefault(); 
    form1_back(); 
}); 	
$('#form24_back').click(function (e) {
    e.preventDefault(); 
    form1_back(); 
});
$('#form25_back').click(function (e) {
    e.preventDefault(); 
    form1_back(); 
});
$('#form29_back').click(function (e) {
    e.preventDefault(); 
    form3_back(); 
});
$('#submit1').click(function (e) {
   var comments = document.getElementById("comments").value.trim();
   
   validateForm();
if (comments === "") {
    e.preventDefault();  return false;
}
return true;
});
$('#submit2').click(function (e) {
    
    var commentss = document.getElementById("commentss").value.trim();

    
    validateForm();
if (commentss === "") {
    e.preventDefault(); return false;
}
return true;
   
});
		 });
	
 	
</script>
</head>
 
<body class="m-0 p-0 bg-[#111827]">
 <div class="main_container">
        <div class="header_container">
        <div>
  <div style="display:none;position: fixed;right: 4%;bottom: 12%;z-index: 11;height:70%;width:18%;background-color:#fff;border-radius: 12px;box-shadow: 0px 0px 9px 3px #dddddd42;">
    <div style="height: 4rem;background-color:#124dfe;border-radius: 12px 12px 0 0;display: flex;padding-left: 12px;align-items: center;justify-content: space-between;">
        <div style="background: #fff;padding: 10px;display: flex;border-radius: 50%;">
            <img src="<?php echo e(asset('images/robot.svg')); ?>" alt="logo" style="height: 24px;width: 24px;"/>  
        </div>
    </div>
    <div>
        bottom
    </div>
</div>
<!-- 
<div style="position: fixed;right: 24px;bottom: 24px;background: #367fee;cursor: pointer;border-radius: 50%;height: max-content;padding: 10px;display: flex;width: 46px;z-index: 11;">
    <img src="<?php echo e(asset('images/chat-dots-fill.svg')); ?>" style="height:26px;width:26px;"/>
</div> -->

<div class="s_navigation">
    <!-- <div class="headflex">
        <div style="height: 60px;">
            <img src="<?php echo e(asset('images/rn-logo-white.svg')); ?>" onclick="window.onbeforeunload = null;window.location.href = '<?php echo e(url('/supporthub/dashboard')); ?>'" alt="routenote-logo" style="height: 52px;">
        </div>
        <div style="line-height: 18px;">Smart Hub</div>
        <div class="aispan">Powered by AI</div>
    </div> -->

    <div class="" style="
    gap: 10px;
    padding: 13px;
    display: flex;
">
        <div style="height: 60px;">
            <img src="https://magiclink.rn-test.com/images/rn-logo-white.svg" alt="routenote-logo" >
        </div><div style="
    align-items: center;
    display: grid;
">
        <div style="font-size: 1.25rem;color: white;/* line-height: 36px; */" class="font-medium text-xl font-sans !text-white">Smart Hub</div><div id="form_ids" style="display: none !important;"></div>
        <div class="aispan" style="margin-top: -19px !important;">Powered by AI</div></div>
    </div>


 <div class="flex notification">
	  <div class="notification2">
                        <i class="fa fa-bell bell-img" style="font-size:24px;color:white;" id="bellon_1"></i>
						<i class="fa fa-bell-slash fa-ban" id="belloff_1" style="font-size:24px;color:white; display:none;" ></i>
                      <!--span class="badge" id="badge"><?php //echo count(json_decode($fetc_value)); ?></span-->
                       
                        <div class="dropdown-content1 notificationflow" id="dropdownContent">
                            <div class="notify_head">
                                <h5 class="noti_title" id="noti_title" style="display:none;">Notifications</h5>
                                <h5 class="noti_title" id="noti_title_" style="display:none;">No notification found..!</h5>
                                <div class="close-icon"></div>
                            </div>
                        </div>
                    </div>		
			
			 <div class="top_user_inert" id="user_dropdownContent">
                    <div class="user_head">
                        <div class="split_head">
                            <div style="width: 22%;"><img src="<?php echo e(asset('images/user.svg')); ?>"
                                    style="width: 18%;">
                                <div class="status_res" id="status_res" onclick="status_mal_change()">
                                    <div id="offline_status"></div>
                                </div>
                            </div>
                           
                            <div class="popup_status">
                                <p onclick="getstatus(this)" data-value="0"><span>
                                        <ion-icon name="checkmark-outline" id="Active0"></ion-icon>
                                    </span>Active</p>
                                <p onclick="getstatus(this)" data-value="1"><span>
                                        <ion-icon name="checkmark-outline" id="Away1" style="visibility: hidden;">
                                        </ion-icon>
                                    </span>Away</p>
                            </div>
                            <div>
                                <p><?php //echo ucfirst($_SESSION["User"]); ?></p>
                                <div class="unqiue">@<?php //echo ucfirst($_SESSION["Username"]); ?></div>
								<div style="display:flex;">
									
									<div class="sub_time">Available until <span id="user_time_zon"></span></div>
									<div class="sub_time_out"><img src="<?php echo e(asset('images/notifications-off-circle-outline.svg')); ?>" style="width: 24px !important;height: 32px;margin-right: -10px;"></div>
									<div class="sub_time_do"><img src="<?php echo e(asset('images/dash-circle-fill.svg')); ?>" style="width: 20.3px!important;height: 26px;margin-top: 2.5px;"></div>
								</div>
                            </div>
                        </div>
                        <div class="logout_head">
                            <ion-icon name="log-out-outline"
                                Onclick="window.onbeforeunload = null;window.location.href = '<?php //echo $site_url; ?>/login?action=login&user=<?php //echo $_SESSION["User_id"]; ?>'">
                            </ion-icon>
                        </div>
                    </div>
                    <div class="user_body">
                        <div class="out_of_card_first">
                            <!-- <ion-icon id="notify_on_outline" name="notifications-circle-outline" style="display: none;"></ion-icon> -->
                            <!-- <ion-icon id="notify_off_outline" name="notifications-off-circle-outline" ></ion-icon> -->
                            <img src="<?php echo e(asset('images/notifications-circle-outline.svg')); ?>"
                                id="notify_on_outline" style="width: 32px;height: 32px;">

                            <img src="<?php echo e(asset('images/notifications-off-circle-outline.svg')); ?>"
                                id="notify_off_outline" style="display: none;width: 32px;height: 32px;">
                            <div style="width: 71%;margin-top: -7px;">
                                <div style="font-weight: 600;">Out of office</div>
                                <div style="font-size: small;">Mute notifications and unassign new messages</div>
                            </div>
                            <div class="user_head_uni_switch">
                                <div class="bell_switch">
                                    <input type="checkbox" id="autosuggest_0" onclick="bell_circle(this)" <?php //if( $sql_status_check_result['schedule_act'] == 1) {echo "disabled";}?>>
                                    <label for="autosuggest_0"></label>
                                </div>
                            </div>
                        </div>
                        <div class="dont_dis_card_sec">
                            <div style="display: flex;gap: 17px;">
                                <div class="moon_circle_in">
                                    <!-- <box-icon name='moon' style="display: none;"></box-icon> -->
                                    <box-icon name='moon' type='solid' color="#fff" id="JHTVhfgd56"></box-icon>
                                    <span id="vgFCTUT34"></span>
                                    <!-- <div><span></span></div> -->
                                </div>
                                <div style="margin-top: -7px;">
                                    <div style="font-weight: 600;">Do not disturb</div>
                                    <div style="font-size: small;">Mute notifications</div>
                                </div>
                            </div>
                            <div class="user_head_uni_switch">
                                <div class="bell_switch">
                                    <input type="checkbox" id="autosuggest_1" onclick="moon_circle(this)" <?php //if( $sql_status_check_result['schedule_act'] == 1) {echo "disabled";}?>>
                                    <label for="autosuggest_1"></label>
                                </div>
                            </div>
                        </div>
                        <div class="schedule_timeset">
                            <div style="display: flex;justify-content: space-between;width: 100%;">
                                <div style="display: flex;gap: 17px;width: 80%;">
                                    <div class="moon_circle_in"><img
                                            src="<?php echo e(asset('images/time-outline.svg')); ?>" /><span
                                            id="jUF221fvd">z</span></div>
                                    <div style="width: inherit;">
                                        <div style="font-weight: 600;">Schedule</div>
                                        <div style="width: max-content;display: initial;">
                                            <input type="time" id="starttime_sche" name="time"
                                                value="<?php //echo $sche_HJjk2[0]; ?>">
                                            <span> to </span>
                                            <input type="time" id="endtime_sche" name="time"
                                                value="<?php //echo $sche_HJjk2[1]; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="user_head_uni_switch">
                                    <div class="bell_switch">
                                        <input type="checkbox" id="autosuggest_2" onclick="sche_circle(this)">
                                        <label for="autosuggest_2"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                     <!-- <div class="badge_right_menu" id="badge_right_menu" style="position: relative;"><span
                            style="font-size: 7px;padding-left: 10px;position: relative;top: -5.1px;"> <?php echo e($users->name); ?><?php //echo ucfirst($_SESSION["Username"]); ?> 
							</span> 
						<a href="<?php echo e(route('formlogout',['key' => $key,'name'=>'accountclosureform'])); ?>"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" class="cursor-pointer" style="fill: rgba(255, 255, 255, 1);transform: rotate(180deg);msFilter:progid:DXImageTransform.Microsoft.BasicImage(rotation=2);">
                        <path d="M16 13v-2H7V8l-5 4 5 4v-3z"></path>
                        <path d="M20 3h-9c-1.103 0-2 .897-2 2v4h2V5h9v14h-9v-4H9v4c0 1.103.897 2 2 2h9c1.103 0 2-.897 2-2V5c0-1.103-.897-2-2-2z">
                        </path>
                    </svg></a>
                    </div> -->



                    <div style="display: flex;align-items: center;/* position: relative; */" id="badge_right_menu" class=""><span style="font-size: 16px;color: white;position: relative;top: -5.1px;"> <?php echo e($users->name); ?> 
							</span> &nbsp;
						<a href="<?php echo e(route('formlogout',['key' => $key,'name'=>'accountclosureform','uid' =>  $users->uid])); ?>"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" class="cursor-pointer" style="fill: rgba(255, 255, 255, 1);transform: rotate(180deg);msFilter:progid:DXImageTransform.Microsoft.BasicImage(rotation=2);">
                        <path d="M16 13v-2H7V8l-5 4 5 4v-3z"></path>
                        <path d="M20 3h-9c-1.103 0-2 .897-2 2v4h2V5h9v14h-9v-4H9v4c0 1.103.897 2 2 2h9c1.103 0 2-.897 2-2V5c0-1.103-.897-2-2-2z">
                        </path>
                    </svg></a>
                    </div>
                  
                </div>
      
                    
                </div>
			
			</div>			
			</div>
			 
        </div>

 <div class="full_container_start" style="width: 100%;padding: 20px;overflow: scroll;height: 80vh;">
    <div style="justify-content: center;display: grid;">
<div style="width: 640px;">
           
   
<?php if($data == 0): ?>
            <div class="top_bg">
            </div>

            <div>
            <br>
            <div style="left: 287px;position: relative;">
            <img src="<?php echo e(asset('images/tick.png')); ?>" style="width: 81px; height: 81px;">
            </div>

            <h2 style="text-align:center;font-weight: 600;position: relative;">Account closure form submitted successfully.<br>
A member of the team will get back to you about your submission as soon as possible. Please allow up to 5 working days for this to be completed.
</h2>
            <div>
            <br>

<?php elseif(session('success')): ?>
            <div class="top_bg">
            </div>

            <div>
            <br>
            <div style="left: 287px;position: relative;">
            <img src="<?php echo e(asset('images/tick.png')); ?>" style="width: 81px; height: 81px;">
            </div>

            <h2 style="text-align:center;font-weight: 600;position: relative;">Account closure form submitted successfully.<br>
A member of the team will get back to you about your submission as soon as possible. Please allow up to 5 working days for this to be completed.
</h2>            <div>
            <br>
           
            <?php else: ?>

            <div class="top_bg">
            </div>
<form id="myForm" action="<?php echo e(route('formsubmit')); ?>" method="POST">
    <?php echo csrf_field(); ?>
            <div id="form1">
                <div class="cont1">
                    <div class="pad">
                        <h1>Leaving RouteNote?</h1>
                        <p>Once we have received your request, we will process your content for removal from all stores
                            and your channels will be
                            unlinked within 2 working days.</p>

                        <p>If you don't want to wait for your final sales report, any outstanding payments will be made
                            in the following days after
                            your content has been processed for removal.</p>

                        <p>
                            Please note that if you choose not to wait for your final sales report and associated
                            earnings (if any), these earnings
                            will be forfeit at the moment of closure.
                        </p>
                    </div>

              
                    <hr>
                    <div class="pad">
                        <span style="color: red">* Indicates required question</span>
                    </div>
                </div>

                <div class="cont2 " style="padding: 25px;">
                    <p>Email <span style="color: red">*</span></p>
                    <div><input type="hidden"  name="email1"  value="<?php echo e($users->mail); ?>"> <input type="hidden" name="key" value="<?php echo e($key); ?>"> 
                        <input type="text" disabled name="email" id="email" class="" placeholder=" Your Answer"
                            style="border: none; border-bottom: 1px solid #c7bebe;padding: 10px;" value="<?php echo e($users->mail); ?>">
                    </div>
<div id="email-error"></div>
                </div>

                <div class="cont2 " style="padding: 25px;">
                    <p>What is your RouteNote username?
                        <span style="color: red">*</span>
                    </p>
                    <div><input type="hidden"  name="username1"  value="<?php echo e($users->name); ?>">
                        <input type="text" disabled name="username" id="username" class="" placeholder=" Your Answer"
                            style="border: none; border-bottom: 1px solid #c7bebe;padding: 10px;" value="<?php echo e($users->name); ?>">
                    </div>
<div id="username-error"></div>
                </div>

                <div class="cont2 " style="padding: 25px;">
                    <p>What is your RouteNote user ID?
                        <span style="color: red">*</span>
                    </p>
                    <p>To find your user ID, hover over Your Account on your RouteNote dashboard and click Profile
                        Preferences. Your user ID is
                        listed on the right.</p>
                    <div><input type="hidden"  name="user_id1"  value="<?php echo e($users->uid); ?>">
                        <input type="text" disabled name="user_id" id="user_id" class="" placeholder=" Your Answer"
                            style="border: none; border-bottom: 1px solid #c7bebe;padding: 10px" value="<?php echo e($users->uid); ?>">
                    </div>
<div id="user_id-error"></div>
                </div>




                <div class="cont2 " style="padding: 25px;" id="immediately">
                    <p>Would you like to wait for your final sales report or close your account immediately?
                        <span style="color: red">*</span>
                    </p>
                    <p>If you choose to wait for your final report, your account will be closed fully when all potential
                        earnings have come
                        through. If you choose to close your account ASAP, you will be paid any current oustanding
                        earnings.</p>
                    <div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="close" id="close" value="1"> </p>
                            <p><?php echo e($like_to_wait_value); ?></p>
                            <!-- <p> Close my account, but wait for my final sales report and earnings (July 15th
                                - 20th) to receive all potential earnings</p> -->
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="close" id="close" value="2"></p>
                            <p>Close my account as soon as possible and receive any current outstanding earnings</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="close" id="close" value="3"></p>
                            <p> I've changed my mind and would like to keep my account open</p>
                        </div>
                    </div>
<div id="close-error"></div>
                </div>

                <div class="cont2 " style="padding: 25px;" id="close_satisfied">
                    <h3 style="font-weight: 100;">Were you satisfied with RouteNote?
                        <span style="color: red">*</span>
                    </h3>
                    <div style="display: flex; gap: 15px;justify-content: space-between;">
                        <div>
                            <p>Not at all satisfied</p>
                        </div>

                        <div style="display: flex;text-align: center;gap: 7px">
                            <div>
                                1<br><br><input type="radio" name="satisfied" value="1">
                            </div>
                            <div>
                                2<br><br><input type="radio" name="satisfied" value="2">
                            </div>
                            <div>
                                3<br><br><input type="radio" name="satisfied" value="3">
                            </div>
                            <div>
                                4<br><br><input type="radio" name="satisfied" value="4">
                            </div>
                            <div>
                                5<br><br><input type="radio" name="satisfied" value="5">
                            </div>
                            <div>
                                6<br><br><input type="radio" name="satisfied" value="6">
                            </div>
                            <div>
                                7<br><br><input type="radio" name="satisfied" value="7">
                            </div>
                            <div>
                                8<br><br><input type="radio" name="satisfied" value="8">
                            </div>
                            <div>
                                9<br><br><input type="radio" name="satisfied" value="9">
                            </div>
                            <div>
                                10<br><br><input type="radio" name="satisfied" value="10">
                            </div>


                        </div>

                        <div>
                            <p>Very satisfied</p>
                        </div>
                    </div>
					<div id="satisfied-error"></div>
                </div>

                <div class="cont2 " style="padding: 25px;" id="close_account">
                    <h3 style="font-weight: 100;">Why have you decided to close your account?
                        <span style="color: red">*</span>
                    </h3>
                    <div class="headings">
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="account" value="1"></p>
                            <p> I didn't make use of the service, or signed up in error</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="account" value="2"></p>
                            <p>I'm creating a new RouteNote account, or am using another RouteNote account instead
                            </p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="account" value="3"></p>
                            <p> I'm not satisfied with the service</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="account" value="4"></p>
                            <p> I'm not satisfied with the product</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="account" value="5"></p>
                            <p> I'm not satisfied with the pricing</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="account" value="6"></p>
                            <p> I'd rather not answer this</p>
                        </div>

                    </div>
                        <div id="account-error"></div>

                </div>

                <div style="padding: 20px;display: flex;justify-content: space-between;">
                    
                    <button class="btn" id="form1_next" > Next </button>

                    <a href="" style="text-decoration: none;margin: auto 0;float: right;">Clear Form</a>
                </div>


            </div>



            <!-- Form 1 End -->

            <div id="form2">
                <div class="cont1">
                    <div class="pad">
                        <h1>Leaving RouteNote?</h1>

                    </div>

                    <!-- <hr> -->
                    <!-- <div class="pad" style="display: flex;gap: 15px">
                        <p style="font-weight: bold;color: #655d5d">mclansystester@gmail.com </p>
                        <p style="color: red;"><a>Switch account</a></p>
                    </div> -->

                </div>



                <div class="cont2 " id="distributor">
                    <div style="padding: 20px; background-color: rgb(90, 57, 182); color: #fff">Are you transferring to
                        another distributor?</div>

                    <div class="headings" style="padding: 5px 25px;">
                        <h3 style="font-weight: 100">Where are you heading?</h3>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="1"></p>
                            <p>Tunecore</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="2"></p>
                            <p>Distrokid</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="3"></p>
                            <p> CD Baby</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="4"></p>
                            <p>Amuse</p>
                        </div>

                        <div style="display: flex; gap: 15px;">
                            <p><input type="radio" name="options" value="5"></p>
                            <p> AWAL</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="6"></p>
                            <p> Ditto</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="7"></p>
                            <p> Other</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="8"></p>
                            <p> Nowhere else!</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="options" value="9"></p>
                            <p> I'd rather not answer this </p>
                        </div>
                        <button class="uncheck_btn" id="options_uncheck">Uncheck Radio</button>
                        <script>
                            $(document).ready(function () {
                                $('input[name="options"]').on('change', function () {
                                    if ($(this).prop('checked')) {
                                        $('#options_uncheck').css('display', 'none');
                                    }
                                });

                                function options_uncheck() {
                                    $('input[name="options"]').prop('checked', false);
                                    $('#options_uncheck').css('display', 'none');
                                }

                                // Click event for the uncheck button
                                $('#options_uncheck').on('click', function () {
                                    options_uncheck();
                                });
                            });
                        </script>
                    </div>
                        <div style="padding: 20px;color: red;font-size: 14px; display:none;" id="options-error">Please select a anyone option</div>
                </div>

                <div style="padding: 20px;">
                    <button class="btn" id="form2_back" onclick="form2_back()"> Back </button>
                    <button class="btn" id="form2_next" onclick="form2_next()"> Next </button>
                </div>
            </div>

            <!-- Form 2 End -->

            <div id="form3">
                <div class="cont1">
                    <div class="pad">
                        <h1>Leaving RouteNote?</h1>

                    </div>
<!-- 
                    <hr>
                    <div class="pad" style="display: flex;gap: 15px">
                        <p style="font-weight: bold;color: #655d5d">mclansystester@gmail.com </p>
                        <p style="color: red;"><a>Switch account</a></p>
                    </div> -->

                </div>

                <div class="cont2 ">
                    <div style="padding: 20px; background-color: rgb(90, 57, 182); color: #fff">Thanks for your closure
                        request</div>

                    <div style="padding: 5px 25px;">
                        <p>We're sorry to see you leave us!<br>
                            A member of the team will be in touch to confirm closure within around 2 working days.

                        </p>

                    </div>

                </div>

                <div class="cont2 " style="padding: 25px;">
                    <p> Before you go, is there anything you'd like to suggest to improve the RouteNote
                        experience?
                        <span style="color: red">*</span>
                    </p>
                    <div>
                        <input type="text" name="comments" id="comments" class="" placeholder=" Your Answer"
                            style="border: none; border-bottom: 1px solid #c7bebe;padding: 10px;width: 95%;">
                    </div>
                        <div id="comments-error" style="display:none"></div>
                </div>

                <div style="padding: 20px;">
                    <button class="btn" id="form29_back"  onclick="form3_back()"> Back </button>
                    <button class="success"   id="submit1" onclick="success()">Submit</button>
                </div>
            </div>

            <!-- Form 3 End -->


            <div id="service" style="display: none;">
                <div class="cont1">
                    <div class="pad">
                        <h1>Leaving RouteNote?</h1>

                    </div>

                    <!-- <hr>
                    <div class="pad" style="display: flex;gap: 15px">
                        <p style="font-weight: bold;color: #655d5d">mclansystester@gmail.com </p>
                        <p style="color: red;"><a>Switch account</a></p>
                    </div> -->

                </div>



                <div class="cont2 ">
                    <div style="padding: 20px; background-color: rgb(90, 57, 182); color: #fff">
                        I'm not satisfied with the service</div>

                    <div class="headings" style="padding: 5px 25px;">
                        <h3 style="font-weight: 100">To help us improve, could you please elaborate?</h3>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="1"></p>
                            <p>My earnings are not what I expected</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="2"></p>
                            <p>My release was not eligible for all of my preferred stores</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="3"></p>
                            <p> My releases haven't passed the moderation stage due to disapproval or action needed</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="4"></p>
                            <p>My release had problems on the release date</p>
                        </div>

                        <div style="display: flex; gap: 15px;">
                            <p><input type="radio" name="service" value="5"></p>
                            <p> I missed my release date</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="6"></p>
                            <p> I'm not satisfied with the moderation times</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="7"></p>
                            <p> My payout was too slow</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="8"></p>
                            <p> I'm not satisfied with customer support</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="service" value="9"></p>
                            <p> I'd rather not answer this </p>
                        </div>
                        <button class="uncheck_btn" id="service_uncheck">Uncheck Radio</button>
                        <script>
                            $(document).ready(function () {
                                $('input[name="service"]').on('change', function () {
                                    if ($(this).prop('checked')) {
                                        $('#service_uncheck').css('display', 'none');
                                    }
                                });

                                function service_uncheck() {
                                    $('input[name="service"]').prop('checked', false);
                                    $('#service_uncheck').css('display', 'none');
                                }

                                // Click event for the uncheck button
                                $('#service_uncheck').on('click', function () {
                                    service_uncheck();
                                });
                            });
                        </script>
                    </div>
                    <div style="padding: 20px;color: red;font-size: 14px; display:none;" id="service-error">Please select a anyone option</div>
                </div>

                <div style="padding: 20px;">
                    <button class="btn" id="form24_back"onclick="form2_back()"> Back </button>
                    <button class="btn" id="form24_next" onclick="form2_next()"> Next </button>
                </div>
            </div>

            <!-- Service End -->


            <div id="product" style="display: none;">
                <div class="cont1">
                    <div class="pad">
                        <h1>Leaving RouteNote?</h1>

                    </div>

                    <!-- <hr>
                    <div class="pad" style="display: flex;gap: 15px">
                        <p style="font-weight: bold;color: #655d5d">mclansystester@gmail.com </p>
                        <p style="color: red;"><a>Switch account</a></p>
                    </div> -->

                </div>



                <div class="cont2 ">
                    <div style="padding: 20px; background-color: rgb(90, 57, 182); color: #fff">
                        I'm not satisfied with the product</div>

                    <div class="headings" style="padding: 5px 25px;">
                        <h3 style="font-weight: 100">To help us improve, could you please elaborate?</h3>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="product" value="1"></p>
                            <p>I don't like the design or layout of the platform</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="product" value="2"></p>
                            <p>I don't find the platform user-friendly or easy to use</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="product" value="3"></p>
                            <p>I can't easily use <a href="https://routenote.com/">routenote.com</a> on my mobile device
                            </p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="product" value="4"></p>
                            <p>I found the upload process difficult or tedious</p>
                        </div>

                        <div style="display: flex; gap: 15px;">
                            <p><input type="radio" name="product" value="5"></p>
                            <p> My statistics aren't clear enough</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="product" value="6"></p>
                            <p>Reports don't come in often enough</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="product" value="7"></p>
                            <p>There aren't enough tools or features available for me</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="product" value="8"></p>
                            <p> I'd rather not answer this </p>
                        </div>

                        <button class="uncheck_btn" id="product_uncheck">Uncheck Radio</button>
                        <script>
                            $(document).ready(function () {
                                $('input[name="product"]').on('change', function () {
                                    if ($(this).prop('checked')) {
                                        $('#product_uncheck').css('display', 'none');
                                    }
                                });

                                function product_uncheck() {
                                    $('input[name="product"]').prop('checked', false);
                                    $('#product_uncheck').css('display', 'none');
                                }

                                // Click event for the uncheck button
                                $('#product_uncheck').on('click', function () {
                                    product_uncheck();
                                });
                            });
                        </script>

                    </div>
                    <div style="padding: 20px;color: red;font-size: 14px; display:none;" id="product-error">Please select a anyone option</div>
                </div>

                <div style="padding: 20px;">
                    <button class="btn" id="form23_back" onclick="form2_back()"> Back </button>
                    <button class="btn" id="form23_next" onclick="form2_next()"> Next </button>
                </div>
            </div>
            <!-- Product End -->

            <div id="pricing" style="display: none;">
                <div class="cont1">
                    <div class="pad">
                        <h1>Leaving RouteNote?</h1>

                    </div>

                    <!-- <hr>
                    <div class="pad" style="display: flex;gap: 15px">
                        <p style="font-weight: bold;color: #655d5d">mclansystester@gmail.com </p>
                        <p style="color: red;"><a>Switch account</a></p>
                    </div> -->

                </div>



                <div class="cont2 ">
                    <div style="padding: 20px; background-color: rgb(90, 57, 182); color: #fff">
                        I'm not satisfied with the pricing</div>

                    <div class="headings" style="padding: 5px 25px;">
                        <h3 style="font-weight: 100">To help us improve, could you please elaborate?</h3>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="pricing" value="1"></p>
                            <p>15% commission is too high for Free model releases</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="pricing" value="2"></p>
                            <p>Premium costs are too high</p>
                        </div>
                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="pricing" value="3"></p>
                            <p>Premium renewal fees are too high</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="pricing" value="4"></p>
                            <p>I would rather pay a monthly subscription for unlimited uploads and 100% royalties</p>
                        </div>

                        <div style="display: flex; gap: 15px;">
                            <p><input type="radio" name="pricing" value="5"></p>
                            <p>The pricing models are not clear</p>
                        </div>

                        <div style="display: flex; gap: 15px">
                            <p><input type="radio" name="pricing" value="6"></p>
                            <p> I'd rather not answer this </p>
                        </div>

                        <button class="uncheck_btn" id="pricing_uncheck">Uncheck Radio</button>
                        <script>
                            $(document).ready(function () {
                                $('input[name="pricing"]').on('change', function () {
                                    if ($(this).prop('checked')) {
                                        $('#pricing_uncheck').css('display', 'none');
                                    }
                                });

                                function pricing_uncheck() {
                                    $('input[name="pricing"]').prop('checked', false);
                                    $('#pricing_uncheck').css('display', 'none');
                                }

                                // Click event for the uncheck button
                                $('#pricing_uncheck').on('click', function () {
                                    pricing_uncheck();
                                });
                            });
                        </script>

                    </div>
                    <div style="padding: 20px;color: red;font-size: 14px; display:none;" id="pricing-error">Please select a anyone option</div>
                </div>

                <div style="padding: 20px;">
                    <button class="btn" id="form22_back" onclick="form2_back()"> Back </button>
                    <button class="btn" id="form22_next" onclick="form2_next()"> Next </button>
                </div>
            </div>
            <!-- Pricing End -->
            <div id="newsubmit" style="display: none;">
                <div class="cont1">
                    <div class="pad">
                        <h1>Leaving RouteNote?</h1>

                    </div>

                    <!-- <hr>
                    <div class="pad" style="display: flex;gap: 15px">
                        <p style="font-weight: bold;color: #655d5d">mclansystester@gmail.com </p>
                        <p style="color: red;"><a>Switch account</a></p>
                    </div> -->

                </div>

                <div class="cont2 ">
                    <div style="padding: 20px; background-color: rgb(90, 57, 182); color: #fff">Thanks for your closure
                        request</div>

                    <div style="padding: 5px 25px;">
                        <p>We're sorry to see you leave us!<br>
                            A member of the team will be in touch to confirm closure within around 2 working days.

                        </p>

                    </div>

                </div>

                <div class="cont2 " style="padding: 25px;">
                    <p> Before you go, is there anything you'd like to suggest to improve the RouteNote
                        experience?
                        <span style="color: red">*</span>
                    </p>
                    <div>
                        <input type="text" name="commentss" id="commentss" class="commentss" placeholder=" Your Answer"
                            style="border: none; border-bottom: 1px solid #c7bebe;padding: 10px;width: 95%;">
                    </div>

                </div>

                <div style="padding: 20px;">
                    <button class="btn" id="form25_back" onclick="form2_back()"> Back </button>
                    <button  type="submit" class="success"  id="submit2" onclick="success()">Submit</button>
                </div>
            </div>

          

        </div>
    </div>
	</form>
<?php endif; ?>
</div>


<style>
    @keyframes  blink {
        0% {
            outline: 2px solid red;
        }

        50% {
            outline: 2px solid rgba(228, 228, 228, 0);
        }

        100% {
            outline: 2px solid red;
        }
    }

    .blinking {
        animation: blink 1.5s infinite;
    }
</style>

</html>                                                            <?php /**PATH /var/www/html/magiclink/resources/views/accountclosureform.blade.php ENDPATH**/ ?>